/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateGroupRequestMarshaller
implements Marshaller<Request<UpdateGroupRequest>, UpdateGroupRequest> {
    public Request<UpdateGroupRequest> marshall(UpdateGroupRequest updateGroupRequest) {
        if (updateGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGroupRequest, "IAMClient");
        request.addParameter("Action", "UpdateGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)updateGroupRequest.groupName()));
        }
        if (updateGroupRequest.newPath() != null) {
            request.addParameter("NewPath", StringUtils.fromString((String)updateGroupRequest.newPath()));
        }
        if (updateGroupRequest.newGroupName() != null) {
            request.addParameter("NewGroupName", StringUtils.fromString((String)updateGroupRequest.newGroupName()));
        }
        return request;
    }
}

