/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.transform.PositionUnmarshaller;

public class StatementUnmarshaller
implements Unmarshaller<Statement, StaxUnmarshallerContext> {
    private static final StatementUnmarshaller INSTANCE = new StatementUnmarshaller();

    public Statement unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Statement.Builder statement = Statement.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourcePolicyId", targetDepth)) {
                    statement.sourcePolicyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourcePolicyType", targetDepth)) {
                    statement.sourcePolicyType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StartPosition", targetDepth)) {
                    statement.startPosition(PositionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EndPosition", targetDepth)) continue;
                statement.endPosition(PositionUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Statement)statement.build();
    }

    public static StatementUnmarshaller getInstance() {
        return INSTANCE;
    }
}

