/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.transform.RoleUnmarshaller;

public class InstanceProfileUnmarshaller
implements Unmarshaller<InstanceProfile, StaxUnmarshallerContext> {
    private static final InstanceProfileUnmarshaller INSTANCE = new InstanceProfileUnmarshaller();

    public InstanceProfile unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceProfile.Builder instanceProfile;
        block10: {
            instanceProfile = InstanceProfile.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Role> roles = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    instanceProfile.roles(roles);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Path", targetDepth)) {
                        instanceProfile.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceProfileName", targetDepth)) {
                        instanceProfile.instanceProfileName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceProfileId", targetDepth)) {
                        instanceProfile.instanceProfileId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Arn", targetDepth)) {
                        instanceProfile.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreateDate", targetDepth)) {
                        instanceProfile.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Roles", targetDepth)) {
                        roles = new ArrayList<Role>();
                        continue;
                    }
                    if (!context.testExpression("Roles/member", targetDepth)) continue;
                    roles.add(RoleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            instanceProfile.roles(roles);
        }
        return (InstanceProfile)instanceProfile.build();
    }

    public static InstanceProfileUnmarshaller getInstance() {
        return INSTANCE;
    }
}

