/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetSSHPublicKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetSSHPublicKeyRequestMarshaller
implements Marshaller<Request<GetSSHPublicKeyRequest>, GetSSHPublicKeyRequest> {
    public Request<GetSSHPublicKeyRequest> marshall(GetSSHPublicKeyRequest getSSHPublicKeyRequest) {
        if (getSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "GetSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)getSSHPublicKeyRequest.userName()));
        }
        if (getSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString((String)getSSHPublicKeyRequest.sshPublicKeyId()));
        }
        if (getSSHPublicKeyRequest.encoding() != null) {
            request.addParameter("Encoding", StringUtils.fromString((String)getSSHPublicKeyRequest.encoding()));
        }
        return request;
    }
}

