/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model._policyDocumentVersionListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ManagedPolicyDetail
implements ToCopyableBuilder<Builder, ManagedPolicyDetail> {
    private final String policyName;
    private final String policyId;
    private final String arn;
    private final String path;
    private final String defaultVersionId;
    private final Integer attachmentCount;
    private final Boolean isAttachable;
    private final String description;
    private final Instant createDate;
    private final Instant updateDate;
    private final List<PolicyVersion> policyVersionList;

    private ManagedPolicyDetail(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyId = builder.policyId;
        this.arn = builder.arn;
        this.path = builder.path;
        this.defaultVersionId = builder.defaultVersionId;
        this.attachmentCount = builder.attachmentCount;
        this.isAttachable = builder.isAttachable;
        this.description = builder.description;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
        this.policyVersionList = builder.policyVersionList;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyId() {
        return this.policyId;
    }

    public String arn() {
        return this.arn;
    }

    public String path() {
        return this.path;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public Integer attachmentCount() {
        return this.attachmentCount;
    }

    public Boolean isAttachable() {
        return this.isAttachable;
    }

    public String description() {
        return this.description;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public List<PolicyVersion> policyVersionList() {
        return this.policyVersionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyId() == null ? 0 : this.policyId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.defaultVersionId() == null ? 0 : this.defaultVersionId().hashCode());
        hashCode = 31 * hashCode + (this.attachmentCount() == null ? 0 : this.attachmentCount().hashCode());
        hashCode = 31 * hashCode + (this.isAttachable() == null ? 0 : this.isAttachable().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.updateDate() == null ? 0 : this.updateDate().hashCode());
        hashCode = 31 * hashCode + (this.policyVersionList() == null ? 0 : this.policyVersionList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedPolicyDetail)) {
            return false;
        }
        ManagedPolicyDetail other = (ManagedPolicyDetail)obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyId() == null ^ this.policyId() == null) {
            return false;
        }
        if (other.policyId() != null && !other.policyId().equals(this.policyId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.defaultVersionId() == null ^ this.defaultVersionId() == null) {
            return false;
        }
        if (other.defaultVersionId() != null && !other.defaultVersionId().equals(this.defaultVersionId())) {
            return false;
        }
        if (other.attachmentCount() == null ^ this.attachmentCount() == null) {
            return false;
        }
        if (other.attachmentCount() != null && !other.attachmentCount().equals(this.attachmentCount())) {
            return false;
        }
        if (other.isAttachable() == null ^ this.isAttachable() == null) {
            return false;
        }
        if (other.isAttachable() != null && !other.isAttachable().equals(this.isAttachable())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        if (other.updateDate() != null && !other.updateDate().equals(this.updateDate())) {
            return false;
        }
        if (other.policyVersionList() == null ^ this.policyVersionList() == null) {
            return false;
        }
        return other.policyVersionList() == null || other.policyVersionList().equals(this.policyVersionList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyId() != null) {
            sb.append("PolicyId: ").append(this.policyId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.defaultVersionId() != null) {
            sb.append("DefaultVersionId: ").append(this.defaultVersionId()).append(",");
        }
        if (this.attachmentCount() != null) {
            sb.append("AttachmentCount: ").append(this.attachmentCount()).append(",");
        }
        if (this.isAttachable() != null) {
            sb.append("IsAttachable: ").append(this.isAttachable()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        if (this.policyVersionList() != null) {
            sb.append("PolicyVersionList: ").append(this.policyVersionList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyId;
        private String arn;
        private String path;
        private String defaultVersionId;
        private Integer attachmentCount;
        private Boolean isAttachable;
        private String description;
        private Instant createDate;
        private Instant updateDate;
        private List<PolicyVersion> policyVersionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedPolicyDetail model) {
            this.setPolicyName(model.policyName);
            this.setPolicyId(model.policyId);
            this.setArn(model.arn);
            this.setPath(model.path);
            this.setDefaultVersionId(model.defaultVersionId);
            this.setAttachmentCount(model.attachmentCount);
            this.setIsAttachable(model.isAttachable);
            this.setDescription(model.description);
            this.setCreateDate(model.createDate);
            this.setUpdateDate(model.updateDate);
            this.setPolicyVersionList(model.policyVersionList);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final Integer getAttachmentCount() {
            return this.attachmentCount;
        }

        @Override
        public final Builder attachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
            return this;
        }

        public final void setAttachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        public final Boolean getIsAttachable() {
            return this.isAttachable;
        }

        @Override
        public final Builder isAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
            return this;
        }

        public final void setIsAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Collection<PolicyVersion> getPolicyVersionList() {
            return this.policyVersionList;
        }

        @Override
        public final Builder policyVersionList(Collection<PolicyVersion> policyVersionList) {
            this.policyVersionList = _policyDocumentVersionListTypeCopier.copy(policyVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(PolicyVersion ... policyVersionList) {
            this.policyVersionList(Arrays.asList(policyVersionList));
            return this;
        }

        public final void setPolicyVersionList(Collection<PolicyVersion> policyVersionList) {
            this.policyVersionList = _policyDocumentVersionListTypeCopier.copy(policyVersionList);
        }

        public ManagedPolicyDetail build() {
            return new ManagedPolicyDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ManagedPolicyDetail> {
        public Builder policyName(String var1);

        public Builder policyId(String var1);

        public Builder arn(String var1);

        public Builder path(String var1);

        public Builder defaultVersionId(String var1);

        public Builder attachmentCount(Integer var1);

        public Builder isAttachable(Boolean var1);

        public Builder description(String var1);

        public Builder createDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder policyVersionList(Collection<PolicyVersion> var1);

        public Builder policyVersionList(PolicyVersion ... var1);
    }
}

