/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model._accessKeyMetadataListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAccessKeysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAccessKeysResponse> {
    private final List<AccessKeyMetadata> accessKeyMetadata;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccessKeysResponse(BuilderImpl builder) {
        this.accessKeyMetadata = builder.accessKeyMetadata;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<AccessKeyMetadata> accessKeyMetadata() {
        return this.accessKeyMetadata;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accessKeyMetadata() == null ? 0 : this.accessKeyMetadata().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessKeysResponse)) {
            return false;
        }
        ListAccessKeysResponse other = (ListAccessKeysResponse)((Object)obj);
        if (other.accessKeyMetadata() == null ^ this.accessKeyMetadata() == null) {
            return false;
        }
        if (other.accessKeyMetadata() != null && !other.accessKeyMetadata().equals(this.accessKeyMetadata())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKeyMetadata() != null) {
            sb.append("AccessKeyMetadata: ").append(this.accessKeyMetadata()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AccessKeyMetadata> accessKeyMetadata;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessKeysResponse model) {
            this.setAccessKeyMetadata(model.accessKeyMetadata);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<AccessKeyMetadata> getAccessKeyMetadata() {
            return this.accessKeyMetadata;
        }

        @Override
        public final Builder accessKeyMetadata(Collection<AccessKeyMetadata> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copy(accessKeyMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeyMetadata(AccessKeyMetadata ... accessKeyMetadata) {
            this.accessKeyMetadata(Arrays.asList(accessKeyMetadata));
            return this;
        }

        public final void setAccessKeyMetadata(Collection<AccessKeyMetadata> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copy(accessKeyMetadata);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListAccessKeysResponse build() {
            return new ListAccessKeysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAccessKeysResponse> {
        public Builder accessKeyMetadata(Collection<AccessKeyMetadata> var1);

        public Builder accessKeyMetadata(AccessKeyMetadata ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

