/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.ContextEntry;

public class ContextEntryUnmarshaller
implements Unmarshaller<ContextEntry, StaxUnmarshallerContext> {
    private static ContextEntryUnmarshaller INSTANCE;

    public ContextEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContextEntry.Builder contextEntry;
        block7: {
            contextEntry = ContextEntry.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> contextKeyValues = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    contextEntry.contextKeyValues(contextKeyValues);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ContextKeyName", targetDepth)) {
                        contextEntry.contextKeyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ContextKeyValues", targetDepth)) {
                        contextKeyValues = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("ContextKeyValues/member", targetDepth)) {
                        contextKeyValues.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("ContextKeyType", targetDepth)) continue;
                    contextEntry.contextKeyType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            contextEntry.contextKeyValues(contextKeyValues);
        }
        return (ContextEntry)contextEntry.build();
    }

    public static ContextEntryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ContextEntryUnmarshaller();
        }
        return INSTANCE;
    }
}

