/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.ActionNameListTypeCopier;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.ContextEntryListTypeCopier;
import software.amazon.awssdk.services.iam.model.ResourceNameListTypeCopier;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SimulateCustomPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SimulateCustomPolicyRequest> {
    private final List<String> policyInputList;
    private final List<String> actionNames;
    private final List<String> resourceArns;
    private final String resourcePolicy;
    private final String resourceOwner;
    private final String callerArn;
    private final List<ContextEntry> contextEntries;
    private final String resourceHandlingOption;
    private final Integer maxItems;
    private final String marker;

    private SimulateCustomPolicyRequest(BuilderImpl builder) {
        this.policyInputList = builder.policyInputList;
        this.actionNames = builder.actionNames;
        this.resourceArns = builder.resourceArns;
        this.resourcePolicy = builder.resourcePolicy;
        this.resourceOwner = builder.resourceOwner;
        this.callerArn = builder.callerArn;
        this.contextEntries = builder.contextEntries;
        this.resourceHandlingOption = builder.resourceHandlingOption;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public List<String> policyInputList() {
        return this.policyInputList;
    }

    public List<String> actionNames() {
        return this.actionNames;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public String resourcePolicy() {
        return this.resourcePolicy;
    }

    public String resourceOwner() {
        return this.resourceOwner;
    }

    public String callerArn() {
        return this.callerArn;
    }

    public List<ContextEntry> contextEntries() {
        return this.contextEntries;
    }

    public String resourceHandlingOption() {
        return this.resourceHandlingOption;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyInputList() == null ? 0 : this.policyInputList().hashCode());
        hashCode = 31 * hashCode + (this.actionNames() == null ? 0 : this.actionNames().hashCode());
        hashCode = 31 * hashCode + (this.resourceArns() == null ? 0 : this.resourceArns().hashCode());
        hashCode = 31 * hashCode + (this.resourcePolicy() == null ? 0 : this.resourcePolicy().hashCode());
        hashCode = 31 * hashCode + (this.resourceOwner() == null ? 0 : this.resourceOwner().hashCode());
        hashCode = 31 * hashCode + (this.callerArn() == null ? 0 : this.callerArn().hashCode());
        hashCode = 31 * hashCode + (this.contextEntries() == null ? 0 : this.contextEntries().hashCode());
        hashCode = 31 * hashCode + (this.resourceHandlingOption() == null ? 0 : this.resourceHandlingOption().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulateCustomPolicyRequest)) {
            return false;
        }
        SimulateCustomPolicyRequest other = (SimulateCustomPolicyRequest)((Object)obj);
        if (other.policyInputList() == null ^ this.policyInputList() == null) {
            return false;
        }
        if (other.policyInputList() != null && !other.policyInputList().equals(this.policyInputList())) {
            return false;
        }
        if (other.actionNames() == null ^ this.actionNames() == null) {
            return false;
        }
        if (other.actionNames() != null && !other.actionNames().equals(this.actionNames())) {
            return false;
        }
        if (other.resourceArns() == null ^ this.resourceArns() == null) {
            return false;
        }
        if (other.resourceArns() != null && !other.resourceArns().equals(this.resourceArns())) {
            return false;
        }
        if (other.resourcePolicy() == null ^ this.resourcePolicy() == null) {
            return false;
        }
        if (other.resourcePolicy() != null && !other.resourcePolicy().equals(this.resourcePolicy())) {
            return false;
        }
        if (other.resourceOwner() == null ^ this.resourceOwner() == null) {
            return false;
        }
        if (other.resourceOwner() != null && !other.resourceOwner().equals(this.resourceOwner())) {
            return false;
        }
        if (other.callerArn() == null ^ this.callerArn() == null) {
            return false;
        }
        if (other.callerArn() != null && !other.callerArn().equals(this.callerArn())) {
            return false;
        }
        if (other.contextEntries() == null ^ this.contextEntries() == null) {
            return false;
        }
        if (other.contextEntries() != null && !other.contextEntries().equals(this.contextEntries())) {
            return false;
        }
        if (other.resourceHandlingOption() == null ^ this.resourceHandlingOption() == null) {
            return false;
        }
        if (other.resourceHandlingOption() != null && !other.resourceHandlingOption().equals(this.resourceHandlingOption())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyInputList() != null) {
            sb.append("PolicyInputList: ").append(this.policyInputList()).append(",");
        }
        if (this.actionNames() != null) {
            sb.append("ActionNames: ").append(this.actionNames()).append(",");
        }
        if (this.resourceArns() != null) {
            sb.append("ResourceArns: ").append(this.resourceArns()).append(",");
        }
        if (this.resourcePolicy() != null) {
            sb.append("ResourcePolicy: ").append(this.resourcePolicy()).append(",");
        }
        if (this.resourceOwner() != null) {
            sb.append("ResourceOwner: ").append(this.resourceOwner()).append(",");
        }
        if (this.callerArn() != null) {
            sb.append("CallerArn: ").append(this.callerArn()).append(",");
        }
        if (this.contextEntries() != null) {
            sb.append("ContextEntries: ").append(this.contextEntries()).append(",");
        }
        if (this.resourceHandlingOption() != null) {
            sb.append("ResourceHandlingOption: ").append(this.resourceHandlingOption()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> policyInputList;
        private List<String> actionNames;
        private List<String> resourceArns;
        private String resourcePolicy;
        private String resourceOwner;
        private String callerArn;
        private List<ContextEntry> contextEntries;
        private String resourceHandlingOption;
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulateCustomPolicyRequest model) {
            this.setPolicyInputList(model.policyInputList);
            this.setActionNames(model.actionNames);
            this.setResourceArns(model.resourceArns);
            this.setResourcePolicy(model.resourcePolicy);
            this.setResourceOwner(model.resourceOwner);
            this.setCallerArn(model.callerArn);
            this.setContextEntries(model.contextEntries);
            this.setResourceHandlingOption(model.resourceHandlingOption);
            this.setMaxItems(model.maxItems);
            this.setMarker(model.marker);
        }

        public final Collection<String> getPolicyInputList() {
            return this.policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @SafeVarargs
        public final void setPolicyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
        }

        public final Collection<String> getActionNames() {
            return this.actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionNameListTypeCopier.copy(actionNames);
        }

        @SafeVarargs
        public final void setActionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceNameListTypeCopier.copy(resourceArns);
        }

        @SafeVarargs
        public final void setResourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getCallerArn() {
            return this.callerArn;
        }

        @Override
        public final Builder callerArn(String callerArn) {
            this.callerArn = callerArn;
            return this;
        }

        public final void setCallerArn(String callerArn) {
            this.callerArn = callerArn;
        }

        public final Collection<ContextEntry> getContextEntries() {
            return this.contextEntries;
        }

        @Override
        public final Builder contextEntries(Collection<ContextEntry> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copy(contextEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextEntries(ContextEntry ... contextEntries) {
            this.contextEntries(Arrays.asList(contextEntries));
            return this;
        }

        public final void setContextEntries(Collection<ContextEntry> contextEntries) {
            this.contextEntries = ContextEntryListTypeCopier.copy(contextEntries);
        }

        @SafeVarargs
        public final void setContextEntries(ContextEntry ... contextEntries) {
            this.contextEntries(Arrays.asList(contextEntries));
        }

        public final String getResourceHandlingOption() {
            return this.resourceHandlingOption;
        }

        @Override
        public final Builder resourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
            return this;
        }

        public final void setResourceHandlingOption(String resourceHandlingOption) {
            this.resourceHandlingOption = resourceHandlingOption;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public SimulateCustomPolicyRequest build() {
            return new SimulateCustomPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SimulateCustomPolicyRequest> {
        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);

        public Builder actionNames(Collection<String> var1);

        public Builder actionNames(String ... var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder resourcePolicy(String var1);

        public Builder resourceOwner(String var1);

        public Builder callerArn(String var1);

        public Builder contextEntries(Collection<ContextEntry> var1);

        public Builder contextEntries(ContextEntry ... var1);

        public Builder resourceHandlingOption(String var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);
    }
}

