/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SigningCertificate
implements ToCopyableBuilder<Builder, SigningCertificate> {
    private final String userName;
    private final String certificateId;
    private final String certificateBody;
    private final String status;
    private final Instant uploadDate;

    private SigningCertificate(BuilderImpl builder) {
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
        this.certificateBody = builder.certificateBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public String userName() {
        return this.userName;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String certificateBody() {
        return this.certificateBody;
    }

    public String status() {
        return this.status;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.certificateBody() == null ? 0 : this.certificateBody().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.uploadDate() == null ? 0 : this.uploadDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningCertificate)) {
            return false;
        }
        SigningCertificate other = (SigningCertificate)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.certificateBody() == null ^ this.certificateBody() == null) {
            return false;
        }
        if (other.certificateBody() != null && !other.certificateBody().equals(this.certificateBody())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.uploadDate() == null ^ this.uploadDate() == null) {
            return false;
        }
        return other.uploadDate() == null || other.uploadDate().equals(this.uploadDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.certificateBody() != null) {
            sb.append("CertificateBody: ").append(this.certificateBody()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.uploadDate() != null) {
            sb.append("UploadDate: ").append(this.uploadDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String certificateId;
        private String certificateBody;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningCertificate model) {
            this.setUserName(model.userName);
            this.setCertificateId(model.certificateId);
            this.setCertificateBody(model.certificateBody);
            this.setStatus(model.status);
            this.setUploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(StatusType status) {
            this.status(status.toString());
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public SigningCertificate build() {
            return new SigningCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SigningCertificate> {
        public Builder userName(String var1);

        public Builder certificateId(String var1);

        public Builder certificateBody(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

