/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServerCertificateMetadata
implements ToCopyableBuilder<Builder, ServerCertificateMetadata> {
    private final String path;
    private final String serverCertificateName;
    private final String serverCertificateId;
    private final String arn;
    private final Instant uploadDate;
    private final Instant expiration;

    private ServerCertificateMetadata(BuilderImpl builder) {
        this.path = builder.path;
        this.serverCertificateName = builder.serverCertificateName;
        this.serverCertificateId = builder.serverCertificateId;
        this.arn = builder.arn;
        this.uploadDate = builder.uploadDate;
        this.expiration = builder.expiration;
    }

    public String path() {
        return this.path;
    }

    public String serverCertificateName() {
        return this.serverCertificateName;
    }

    public String serverCertificateId() {
        return this.serverCertificateId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.serverCertificateName() == null ? 0 : this.serverCertificateName().hashCode());
        hashCode = 31 * hashCode + (this.serverCertificateId() == null ? 0 : this.serverCertificateId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.uploadDate() == null ? 0 : this.uploadDate().hashCode());
        hashCode = 31 * hashCode + (this.expiration() == null ? 0 : this.expiration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateMetadata)) {
            return false;
        }
        ServerCertificateMetadata other = (ServerCertificateMetadata)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.serverCertificateName() == null ^ this.serverCertificateName() == null) {
            return false;
        }
        if (other.serverCertificateName() != null && !other.serverCertificateName().equals(this.serverCertificateName())) {
            return false;
        }
        if (other.serverCertificateId() == null ^ this.serverCertificateId() == null) {
            return false;
        }
        if (other.serverCertificateId() != null && !other.serverCertificateId().equals(this.serverCertificateId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.uploadDate() == null ^ this.uploadDate() == null) {
            return false;
        }
        if (other.uploadDate() != null && !other.uploadDate().equals(this.uploadDate())) {
            return false;
        }
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        return other.expiration() == null || other.expiration().equals(this.expiration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.serverCertificateName() != null) {
            sb.append("ServerCertificateName: ").append(this.serverCertificateName()).append(",");
        }
        if (this.serverCertificateId() != null) {
            sb.append("ServerCertificateId: ").append(this.serverCertificateId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.uploadDate() != null) {
            sb.append("UploadDate: ").append(this.uploadDate()).append(",");
        }
        if (this.expiration() != null) {
            sb.append("Expiration: ").append(this.expiration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String serverCertificateName;
        private String serverCertificateId;
        private String arn;
        private Instant uploadDate;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateMetadata model) {
            this.setPath(model.path);
            this.setServerCertificateName(model.serverCertificateName);
            this.setServerCertificateId(model.serverCertificateId);
            this.setArn(model.arn);
            this.setUploadDate(model.uploadDate);
            this.setExpiration(model.expiration);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getServerCertificateId() {
            return this.serverCertificateId;
        }

        @Override
        public final Builder serverCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
            return this;
        }

        public final void setServerCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public ServerCertificateMetadata build() {
            return new ServerCertificateMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServerCertificateMetadata> {
        public Builder path(String var1);

        public Builder serverCertificateName(String var1);

        public Builder serverCertificateId(String var1);

        public Builder arn(String var1);

        public Builder uploadDate(Instant var1);

        public Builder expiration(Instant var1);
    }
}

