/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model._policyNameListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListUserPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListUserPoliciesResponse> {
    private final List<String> policyNames;
    private final Boolean isTruncated;
    private final String marker;

    private ListUserPoliciesResponse(BuilderImpl builder) {
        this.policyNames = builder.policyNames;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserPoliciesResponse)) {
            return false;
        }
        ListUserPoliciesResponse other = (ListUserPoliciesResponse)((Object)obj);
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        if (other.policyNames() != null && !other.policyNames().equals(this.policyNames())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> policyNames;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserPoliciesResponse model) {
            this.setPolicyNames(model.policyNames);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = _policyNameListTypeCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = _policyNameListTypeCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListUserPoliciesResponse build() {
            return new ListUserPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListUserPoliciesResponse> {
        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

