/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.Policy;
import software.amazon.awssdk.services.iam.model._policyListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPoliciesResponse> {
    private final List<Policy> policies;
    private final Boolean isTruncated;
    private final String marker;

    private ListPoliciesResponse(BuilderImpl builder) {
        this.policies = builder.policies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<Policy> policies() {
        return this.policies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policies() == null ? 0 : this.policies().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse)((Object)obj);
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        if (other.policies() != null && !other.policies().equals(this.policies())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Policy> policies;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            this.setPolicies(model.policies);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<Policy> getPolicies() {
            return this.policies;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = _policyListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<Policy> policies) {
            this.policies = _policyListTypeCopier.copy(policies);
        }

        @SafeVarargs
        public final void setPolicies(Policy ... policies) {
            this.policies(Arrays.asList(policies));
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPoliciesResponse> {
        public Builder policies(Collection<Policy> var1);

        public Builder policies(Policy ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

