/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GroupDetail
implements ToCopyableBuilder<Builder, GroupDetail> {
    private final String path;
    private final String groupName;
    private final String groupId;
    private final String arn;
    private final Instant createDate;
    private final List<PolicyDetail> groupPolicyList;
    private final List<AttachedPolicy> attachedManagedPolicies;

    private GroupDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.groupPolicyList = builder.groupPolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    public String path() {
        return this.path;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<PolicyDetail> groupPolicyList() {
        return this.groupPolicyList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.groupPolicyList() == null ? 0 : this.groupPolicyList().hashCode());
        hashCode = 31 * hashCode + (this.attachedManagedPolicies() == null ? 0 : this.attachedManagedPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupDetail)) {
            return false;
        }
        GroupDetail other = (GroupDetail)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.groupPolicyList() == null ^ this.groupPolicyList() == null) {
            return false;
        }
        if (other.groupPolicyList() != null && !other.groupPolicyList().equals(this.groupPolicyList())) {
            return false;
        }
        if (other.attachedManagedPolicies() == null ^ this.attachedManagedPolicies() == null) {
            return false;
        }
        return other.attachedManagedPolicies() == null || other.attachedManagedPolicies().equals(this.attachedManagedPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.groupPolicyList() != null) {
            sb.append("GroupPolicyList: ").append(this.groupPolicyList()).append(",");
        }
        if (this.attachedManagedPolicies() != null) {
            sb.append("AttachedManagedPolicies: ").append(this.attachedManagedPolicies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String groupName;
        private String groupId;
        private String arn;
        private Instant createDate;
        private List<PolicyDetail> groupPolicyList;
        private List<AttachedPolicy> attachedManagedPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupDetail model) {
            this.setPath(model.path);
            this.setGroupName(model.groupName);
            this.setGroupId(model.groupId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setGroupPolicyList(model.groupPolicyList);
            this.setAttachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<PolicyDetail> getGroupPolicyList() {
            return this.groupPolicyList;
        }

        @Override
        public final Builder groupPolicyList(Collection<PolicyDetail> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copy(groupPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPolicyList(PolicyDetail ... groupPolicyList) {
            this.groupPolicyList(Arrays.asList(groupPolicyList));
            return this;
        }

        public final void setGroupPolicyList(Collection<PolicyDetail> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copy(groupPolicyList);
        }

        @SafeVarargs
        public final void setGroupPolicyList(PolicyDetail ... groupPolicyList) {
            this.groupPolicyList(Arrays.asList(groupPolicyList));
        }

        public final Collection<AttachedPolicy> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
        }

        @SafeVarargs
        public final void setAttachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
        }

        public GroupDetail build() {
            return new GroupDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupDetail> {
        public Builder path(String var1);

        public Builder groupName(String var1);

        public Builder groupId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder groupPolicyList(Collection<PolicyDetail> var1);

        public Builder groupPolicyList(PolicyDetail ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);
    }
}

