/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest;

public class UploadSshPublicKeyRequestMarshaller
implements Marshaller<Request<UploadSshPublicKeyRequest>, UploadSshPublicKeyRequest> {
    public Request<UploadSshPublicKeyRequest> marshall(UploadSshPublicKeyRequest uploadSshPublicKeyRequest) {
        if (uploadSshPublicKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)uploadSshPublicKeyRequest, "IamClient");
        request.addParameter("Action", "UploadSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadSshPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)uploadSshPublicKeyRequest.userName()));
        }
        if (uploadSshPublicKeyRequest.sshPublicKeyBody() != null) {
            request.addParameter("SSHPublicKeyBody", StringConversion.fromString((String)uploadSshPublicKeyRequest.sshPublicKeyBody()));
        }
        return request;
    }
}

