/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;

public class UpdateGroupRequestMarshaller
implements Marshaller<Request<UpdateGroupRequest>, UpdateGroupRequest> {
    public Request<UpdateGroupRequest> marshall(UpdateGroupRequest updateGroupRequest) {
        if (updateGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateGroupRequest, "IamClient");
        request.addParameter("Action", "UpdateGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)updateGroupRequest.groupName()));
        }
        if (updateGroupRequest.newPath() != null) {
            request.addParameter("NewPath", StringConversion.fromString((String)updateGroupRequest.newPath()));
        }
        if (updateGroupRequest.newGroupName() != null) {
            request.addParameter("NewGroupName", StringConversion.fromString((String)updateGroupRequest.newGroupName()));
        }
        return request;
    }
}

