/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.PutUserPolicyRequest;

public class PutUserPolicyRequestMarshaller
implements Marshaller<Request<PutUserPolicyRequest>, PutUserPolicyRequest> {
    public Request<PutUserPolicyRequest> marshall(PutUserPolicyRequest putUserPolicyRequest) {
        if (putUserPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putUserPolicyRequest, "IamClient");
        request.addParameter("Action", "PutUserPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putUserPolicyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)putUserPolicyRequest.userName()));
        }
        if (putUserPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)putUserPolicyRequest.policyName()));
        }
        if (putUserPolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringConversion.fromString((String)putUserPolicyRequest.policyDocument()));
        }
        return request;
    }
}

