/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;

public class GetRolePolicyRequestMarshaller
implements Marshaller<Request<GetRolePolicyRequest>, GetRolePolicyRequest> {
    public Request<GetRolePolicyRequest> marshall(GetRolePolicyRequest getRolePolicyRequest) {
        if (getRolePolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getRolePolicyRequest, "IamClient");
        request.addParameter("Action", "GetRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)getRolePolicyRequest.roleName()));
        }
        if (getRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)getRolePolicyRequest.policyName()));
        }
        return request;
    }
}

