/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualMFADevice
implements ToCopyableBuilder<Builder, VirtualMFADevice> {
    private final String serialNumber;
    private final SdkBytes base32StringSeed;
    private final SdkBytes qrCodePNG;
    private final User user;
    private final Instant enableDate;

    private VirtualMFADevice(BuilderImpl builder) {
        this.serialNumber = builder.serialNumber;
        this.base32StringSeed = builder.base32StringSeed;
        this.qrCodePNG = builder.qrCodePNG;
        this.user = builder.user;
        this.enableDate = builder.enableDate;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public SdkBytes base32StringSeed() {
        return this.base32StringSeed;
    }

    public SdkBytes qrCodePNG() {
        return this.qrCodePNG;
    }

    public User user() {
        return this.user;
    }

    public Instant enableDate() {
        return this.enableDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.base32StringSeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.qrCodePNG());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMFADevice)) {
            return false;
        }
        VirtualMFADevice other = (VirtualMFADevice)obj;
        return Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.base32StringSeed(), other.base32StringSeed()) && Objects.equals(this.qrCodePNG(), other.qrCodePNG()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.enableDate(), other.enableDate());
    }

    public String toString() {
        return ToString.builder((String)"VirtualMFADevice").add("SerialNumber", (Object)this.serialNumber()).add("Base32StringSeed", (Object)this.base32StringSeed()).add("QRCodePNG", (Object)this.qrCodePNG()).add("User", (Object)this.user()).add("EnableDate", (Object)this.enableDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Base32StringSeed": {
                return Optional.ofNullable(clazz.cast(this.base32StringSeed()));
            }
            case "QRCodePNG": {
                return Optional.ofNullable(clazz.cast(this.qrCodePNG()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "EnableDate": {
                return Optional.ofNullable(clazz.cast(this.enableDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serialNumber;
        private SdkBytes base32StringSeed;
        private SdkBytes qrCodePNG;
        private User user;
        private Instant enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMFADevice model) {
            this.serialNumber(model.serialNumber);
            this.base32StringSeed(model.base32StringSeed);
            this.qrCodePNG(model.qrCodePNG);
            this.user(model.user);
            this.enableDate(model.enableDate);
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final ByteBuffer getBase32StringSeed() {
            return this.base32StringSeed == null ? null : this.base32StringSeed.asByteBuffer();
        }

        @Override
        public final Builder base32StringSeed(SdkBytes base32StringSeed) {
            this.base32StringSeed = StandardMemberCopier.copy((SdkBytes)base32StringSeed);
            return this;
        }

        public final void setBase32StringSeed(ByteBuffer base32StringSeed) {
            this.base32StringSeed(base32StringSeed == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)base32StringSeed));
        }

        public final ByteBuffer getQRCodePNG() {
            return this.qrCodePNG == null ? null : this.qrCodePNG.asByteBuffer();
        }

        @Override
        public final Builder qrCodePNG(SdkBytes qrCodePNG) {
            this.qrCodePNG = StandardMemberCopier.copy((SdkBytes)qrCodePNG);
            return this;
        }

        public final void setQRCodePNG(ByteBuffer qrCodePNG) {
            this.qrCodePNG(qrCodePNG == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)qrCodePNG));
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        @Override
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        public VirtualMFADevice build() {
            return new VirtualMFADevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VirtualMFADevice> {
        public Builder serialNumber(String var1);

        public Builder base32StringSeed(SdkBytes var1);

        public Builder qrCodePNG(SdkBytes var1);

        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder enableDate(Instant var1);
    }
}

