/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSshPublicKeyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateSshPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String status;

    private UpdateSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.status = builder.status;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSshPublicKeyRequest)) {
            return false;
        }
        UpdateSshPublicKeyRequest other = (UpdateSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyId(), other.sshPublicKeyId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSshPublicKeyRequest").add("UserName", (Object)this.userName()).add("SSHPublicKeyId", (Object)this.sshPublicKeyId()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSshPublicKeyRequest model) {
            super(model);
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.status(model.status);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSshPublicKeyRequest build() {
            return new UpdateSshPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UpdateSshPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

