/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.EvaluationResultsListTypeCopier;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulateCustomPolicyResponse
extends IamResponse
implements ToCopyableBuilder<Builder, SimulateCustomPolicyResponse> {
    private final List<EvaluationResult> evaluationResults;
    private final Boolean isTruncated;
    private final String marker;

    private SimulateCustomPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulateCustomPolicyResponse)) {
            return false;
        }
        SimulateCustomPolicyResponse other = (SimulateCustomPolicyResponse)((Object)obj);
        return Objects.equals(this.evaluationResults(), other.evaluationResults()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"SimulateCustomPolicyResponse").add("EvaluationResults", this.evaluationResults()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.evaluationResults()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulateCustomPolicyResponse model) {
            super(model);
            this.evaluationResults(model.evaluationResults);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<EvaluationResult.Builder> getEvaluationResults() {
            return this.evaluationResults != null ? (Collection)this.evaluationResults.stream().map(EvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsListTypeCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder> ... evaluationResults) {
            this.evaluationResults(Stream.of(evaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsListTypeCopier.copyFromBuilder(evaluationResults);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public SimulateCustomPolicyResponse build() {
            return new SimulateCustomPolicyResponse(this);
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    CopyableBuilder<Builder, SimulateCustomPolicyResponse> {
        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder evaluationResults(Consumer<EvaluationResult.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

