/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutUserPermissionsBoundaryRequest
extends IamRequest
implements ToCopyableBuilder<Builder, PutUserPermissionsBoundaryRequest> {
    private final String userName;
    private final String permissionsBoundary;

    private PutUserPermissionsBoundaryRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public String userName() {
        return this.userName;
    }

    public String permissionsBoundary() {
        return this.permissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutUserPermissionsBoundaryRequest)) {
            return false;
        }
        PutUserPermissionsBoundaryRequest other = (PutUserPermissionsBoundaryRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public String toString() {
        return ToString.builder((String)"PutUserPermissionsBoundaryRequest").add("UserName", (Object)this.userName()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(PutUserPermissionsBoundaryRequest model) {
            super(model);
            this.userName(model.userName);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final Builder permissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutUserPermissionsBoundaryRequest build() {
            return new PutUserPermissionsBoundaryRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, PutUserPermissionsBoundaryRequest> {
        public Builder userName(String var1);

        public Builder permissionsBoundary(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

