/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest;

public class UpdateSamlProviderRequestMarshaller
implements Marshaller<Request<UpdateSamlProviderRequest>, UpdateSamlProviderRequest> {
    public Request<UpdateSamlProviderRequest> marshall(UpdateSamlProviderRequest updateSamlProviderRequest) {
        if (updateSamlProviderRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateSamlProviderRequest, "IamClient");
        request.addParameter("Action", "UpdateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateSamlProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringConversion.fromString((String)updateSamlProviderRequest.samlMetadataDocument()));
        }
        if (updateSamlProviderRequest.samlProviderArn() != null) {
            request.addParameter("SAMLProviderArn", StringConversion.fromString((String)updateSamlProviderRequest.samlProviderArn()));
        }
        return request;
    }
}

