/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest;

public class UpdateOpenIdConnectProviderThumbprintRequestMarshaller
implements Marshaller<Request<UpdateOpenIdConnectProviderThumbprintRequest>, UpdateOpenIdConnectProviderThumbprintRequest> {
    public Request<UpdateOpenIdConnectProviderThumbprintRequest> marshall(UpdateOpenIdConnectProviderThumbprintRequest updateOpenIdConnectProviderThumbprintRequest) {
        if (updateOpenIdConnectProviderThumbprintRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateOpenIdConnectProviderThumbprintRequest, "IamClient");
        request.addParameter("Action", "UpdateOpenIDConnectProviderThumbprint");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateOpenIdConnectProviderThumbprintRequest.openIDConnectProviderArn() != null) {
            request.addParameter("OpenIDConnectProviderArn", StringConversion.fromString((String)updateOpenIdConnectProviderThumbprintRequest.openIDConnectProviderArn()));
        }
        if (updateOpenIdConnectProviderThumbprintRequest.thumbprintList().isEmpty() && !(updateOpenIdConnectProviderThumbprintRequest.thumbprintList() instanceof SdkAutoConstructList)) {
            request.addParameter("ThumbprintList", "");
        } else if (!updateOpenIdConnectProviderThumbprintRequest.thumbprintList().isEmpty() && !(updateOpenIdConnectProviderThumbprintRequest.thumbprintList() instanceof SdkAutoConstructList)) {
            List<String> thumbprintListList = updateOpenIdConnectProviderThumbprintRequest.thumbprintList();
            int thumbprintListListIndex = 1;
            for (String thumbprintListListValue : thumbprintListList) {
                if (thumbprintListListValue != null) {
                    request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringConversion.fromString((String)thumbprintListListValue));
                }
                ++thumbprintListListIndex;
            }
        }
        return request;
    }
}

