/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;

public class UpdateAccessKeyRequestMarshaller
implements Marshaller<Request<UpdateAccessKeyRequest>, UpdateAccessKeyRequest> {
    public Request<UpdateAccessKeyRequest> marshall(UpdateAccessKeyRequest updateAccessKeyRequest) {
        if (updateAccessKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateAccessKeyRequest, "IamClient");
        request.addParameter("Action", "UpdateAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)updateAccessKeyRequest.userName()));
        }
        if (updateAccessKeyRequest.accessKeyId() != null) {
            request.addParameter("AccessKeyId", StringConversion.fromString((String)updateAccessKeyRequest.accessKeyId()));
        }
        if (updateAccessKeyRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString((String)updateAccessKeyRequest.statusAsString()));
        }
        return request;
    }
}

