/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        if (simulateCustomPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)simulateCustomPolicyRequest, "IamClient");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (simulateCustomPolicyRequest.policyInputList().isEmpty() && !(simulateCustomPolicyRequest.policyInputList() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyInputList", "");
        } else if (!simulateCustomPolicyRequest.policyInputList().isEmpty() && !(simulateCustomPolicyRequest.policyInputList() instanceof SdkAutoConstructList)) {
            List<String> policyInputListList = simulateCustomPolicyRequest.policyInputList();
            int policyInputListListIndex = 1;
            for (String policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringConversion.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (simulateCustomPolicyRequest.actionNames().isEmpty() && !(simulateCustomPolicyRequest.actionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ActionNames", "");
        } else if (!simulateCustomPolicyRequest.actionNames().isEmpty() && !(simulateCustomPolicyRequest.actionNames() instanceof SdkAutoConstructList)) {
            List<String> actionNamesList = simulateCustomPolicyRequest.actionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringConversion.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (simulateCustomPolicyRequest.resourceArns().isEmpty() && !(simulateCustomPolicyRequest.resourceArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceArns", "");
        } else if (!simulateCustomPolicyRequest.resourceArns().isEmpty() && !(simulateCustomPolicyRequest.resourceArns() instanceof SdkAutoConstructList)) {
            List<String> resourceArnsList = simulateCustomPolicyRequest.resourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringConversion.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulateCustomPolicyRequest.resourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringConversion.fromString((String)simulateCustomPolicyRequest.resourcePolicy()));
        }
        if (simulateCustomPolicyRequest.resourceOwner() != null) {
            request.addParameter("ResourceOwner", StringConversion.fromString((String)simulateCustomPolicyRequest.resourceOwner()));
        }
        if (simulateCustomPolicyRequest.callerArn() != null) {
            request.addParameter("CallerArn", StringConversion.fromString((String)simulateCustomPolicyRequest.callerArn()));
        }
        if (simulateCustomPolicyRequest.contextEntries().isEmpty() && !(simulateCustomPolicyRequest.contextEntries() instanceof SdkAutoConstructList)) {
            request.addParameter("ContextEntries", "");
        } else if (!simulateCustomPolicyRequest.contextEntries().isEmpty() && !(simulateCustomPolicyRequest.contextEntries() instanceof SdkAutoConstructList)) {
            List<ContextEntry> contextEntriesList = simulateCustomPolicyRequest.contextEntries();
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                if (contextEntriesListValue.contextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringConversion.fromString((String)contextEntriesListValue.contextKeyName()));
                }
                if (contextEntriesListValue.contextKeyValues().isEmpty() && !(contextEntriesListValue.contextKeyValues() instanceof SdkAutoConstructList)) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues", "");
                } else if (!contextEntriesListValue.contextKeyValues().isEmpty() && !(contextEntriesListValue.contextKeyValues() instanceof SdkAutoConstructList)) {
                    List<String> contextKeyValuesList = contextEntriesListValue.contextKeyValues();
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringConversion.fromString((String)contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.contextKeyTypeAsString() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringConversion.fromString((String)contextEntriesListValue.contextKeyTypeAsString()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulateCustomPolicyRequest.resourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringConversion.fromString((String)simulateCustomPolicyRequest.resourceHandlingOption()));
        }
        if (simulateCustomPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)simulateCustomPolicyRequest.maxItems()));
        }
        if (simulateCustomPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)simulateCustomPolicyRequest.marker()));
        }
        return request;
    }
}

