/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;

public class ListPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListPolicyVersionsRequest>, ListPolicyVersionsRequest> {
    public Request<ListPolicyVersionsRequest> marshall(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        if (listPolicyVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listPolicyVersionsRequest, "IamClient");
        request.addParameter("Action", "ListPolicyVersions");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPolicyVersionsRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringConversion.fromString((String)listPolicyVersionsRequest.policyArn()));
        }
        if (listPolicyVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listPolicyVersionsRequest.marker()));
        }
        if (listPolicyVersionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listPolicyVersionsRequest.maxItems()));
        }
        return request;
    }
}

