/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listPoliciesRequest, "IamClient");
        request.addParameter("Action", "ListPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPoliciesRequest.scopeAsString() != null) {
            request.addParameter("Scope", StringConversion.fromString((String)listPoliciesRequest.scopeAsString()));
        }
        if (listPoliciesRequest.onlyAttached() != null) {
            request.addParameter("OnlyAttached", StringConversion.fromBoolean((Boolean)listPoliciesRequest.onlyAttached()));
        }
        if (listPoliciesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringConversion.fromString((String)listPoliciesRequest.pathPrefix()));
        }
        if (listPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listPoliciesRequest.marker()));
        }
        if (listPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listPoliciesRequest.maxItems()));
        }
        return request;
    }
}

