/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;

public class GetAccountAuthorizationDetailsRequestMarshaller
implements Marshaller<Request<GetAccountAuthorizationDetailsRequest>, GetAccountAuthorizationDetailsRequest> {
    public Request<GetAccountAuthorizationDetailsRequest> marshall(GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) {
        if (getAccountAuthorizationDetailsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getAccountAuthorizationDetailsRequest, "IamClient");
        request.addParameter("Action", "GetAccountAuthorizationDetails");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getAccountAuthorizationDetailsRequest.filterAsStrings().isEmpty() && !(getAccountAuthorizationDetailsRequest.filterAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Filter", "");
        } else if (!getAccountAuthorizationDetailsRequest.filterAsStrings().isEmpty() && !(getAccountAuthorizationDetailsRequest.filterAsStrings() instanceof SdkAutoConstructList)) {
            List<String> filterList = getAccountAuthorizationDetailsRequest.filterAsStrings();
            int filterListIndex = 1;
            for (String filterListValue : filterList) {
                if (filterListValue != null) {
                    request.addParameter("Filter.member." + filterListIndex, StringConversion.fromString((String)filterListValue));
                }
                ++filterListIndex;
            }
        }
        if (getAccountAuthorizationDetailsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)getAccountAuthorizationDetailsRequest.maxItems()));
        }
        if (getAccountAuthorizationDetailsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)getAccountAuthorizationDetailsRequest.marker()));
        }
        return request;
    }
}

