/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;

public class CreatePolicyRequestMarshaller
implements Marshaller<Request<CreatePolicyRequest>, CreatePolicyRequest> {
    public Request<CreatePolicyRequest> marshall(CreatePolicyRequest createPolicyRequest) {
        if (createPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createPolicyRequest, "IamClient");
        request.addParameter("Action", "CreatePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)createPolicyRequest.policyName()));
        }
        if (createPolicyRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)createPolicyRequest.path()));
        }
        if (createPolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringConversion.fromString((String)createPolicyRequest.policyDocument()));
        }
        if (createPolicyRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createPolicyRequest.description()));
        }
        return request;
    }
}

