/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;

public class ListRolePoliciesPublisher
implements SdkPublisher<ListRolePoliciesResponse> {
    private final IamAsyncClient client;
    private final ListRolePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRolePoliciesPublisher(IamAsyncClient client, ListRolePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRolePoliciesPublisher(IamAsyncClient client, ListRolePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRolePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRolePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> policyNames() {
        Function<ListRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRolePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListRolePoliciesPublisher resume(ListRolePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRolePoliciesPublisher(this.client, (ListRolePoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListRolePoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListRolePoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListRolePoliciesResponseFetcher
    implements AsyncPageFetcher<ListRolePoliciesResponse> {
        private ListRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListRolePoliciesResponse> nextPage(ListRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListRolePoliciesPublisher.this.client.listRolePolicies(ListRolePoliciesPublisher.this.firstRequest);
            }
            return ListRolePoliciesPublisher.this.client.listRolePolicies((ListRolePoliciesRequest)((Object)ListRolePoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

