/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;

public class ListInstanceProfilesForRolePublisher
implements SdkPublisher<ListInstanceProfilesForRoleResponse> {
    private final IamAsyncClient client;
    private final ListInstanceProfilesForRoleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceProfilesForRolePublisher(IamAsyncClient client, ListInstanceProfilesForRoleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceProfilesForRolePublisher(IamAsyncClient client, ListInstanceProfilesForRoleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceProfilesForRoleResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceProfilesForRoleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesForRoleResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProfiles() != null) {
                return response.instanceProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceProfilesForRoleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListInstanceProfilesForRolePublisher resume(ListInstanceProfilesForRoleResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceProfilesForRolePublisher(this.client, (ListInstanceProfilesForRoleRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceProfilesForRolePublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstanceProfilesForRoleResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstanceProfilesForRoleResponseFetcher
    implements AsyncPageFetcher<ListInstanceProfilesForRoleResponse> {
        private ListInstanceProfilesForRoleResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesForRoleResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListInstanceProfilesForRoleResponse> nextPage(ListInstanceProfilesForRoleResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesForRolePublisher.this.client.listInstanceProfilesForRole(ListInstanceProfilesForRolePublisher.this.firstRequest);
            }
            return ListInstanceProfilesForRolePublisher.this.client.listInstanceProfilesForRole((ListInstanceProfilesForRoleRequest)((Object)ListInstanceProfilesForRolePublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

