/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyGroupListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyRoleListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyUser;
import software.amazon.awssdk.services.iam.model.PolicyUserListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesForPolicyResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
    private final List<PolicyGroup> policyGroups;
    private final List<PolicyUser> policyUsers;
    private final List<PolicyRole> policyRoles;
    private final Boolean isTruncated;
    private final String marker;

    private ListEntitiesForPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyGroups = builder.policyGroups;
        this.policyUsers = builder.policyUsers;
        this.policyRoles = builder.policyRoles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyGroup> policyGroups() {
        return this.policyGroups;
    }

    public List<PolicyUser> policyUsers() {
        return this.policyUsers;
    }

    public List<PolicyRole> policyRoles() {
        return this.policyRoles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyRoles());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResponse)) {
            return false;
        }
        ListEntitiesForPolicyResponse other = (ListEntitiesForPolicyResponse)((Object)obj);
        return Objects.equals(this.policyGroups(), other.policyGroups()) && Objects.equals(this.policyUsers(), other.policyUsers()) && Objects.equals(this.policyRoles(), other.policyRoles()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListEntitiesForPolicyResponse").add("PolicyGroups", this.policyGroups()).add("PolicyUsers", this.policyUsers()).add("PolicyRoles", this.policyRoles()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyGroups": {
                return Optional.ofNullable(clazz.cast(this.policyGroups()));
            }
            case "PolicyUsers": {
                return Optional.ofNullable(clazz.cast(this.policyUsers()));
            }
            case "PolicyRoles": {
                return Optional.ofNullable(clazz.cast(this.policyRoles()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<PolicyGroup> policyGroups = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyUser> policyUsers = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyRole> policyRoles = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyResponse model) {
            super(model);
            this.policyGroups(model.policyGroups);
            this.policyUsers(model.policyUsers);
            this.policyRoles(model.policyRoles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<PolicyGroup.Builder> getPolicyGroups() {
            return this.policyGroups != null ? (Collection)this.policyGroups.stream().map(PolicyGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(PolicyGroup ... policyGroups) {
            this.policyGroups(Arrays.asList(policyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(Consumer<PolicyGroup.Builder> ... policyGroups) {
            this.policyGroups(Stream.of(policyGroups).map(c -> (PolicyGroup)((PolicyGroup.Builder)PolicyGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyGroups(Collection<PolicyGroup.BuilderImpl> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copyFromBuilder(policyGroups);
        }

        public final Collection<PolicyUser.Builder> getPolicyUsers() {
            return this.policyUsers != null ? (Collection)this.policyUsers.stream().map(PolicyUser::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(PolicyUser ... policyUsers) {
            this.policyUsers(Arrays.asList(policyUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(Consumer<PolicyUser.Builder> ... policyUsers) {
            this.policyUsers(Stream.of(policyUsers).map(c -> (PolicyUser)((PolicyUser.Builder)PolicyUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyUsers(Collection<PolicyUser.BuilderImpl> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copyFromBuilder(policyUsers);
        }

        public final Collection<PolicyRole.Builder> getPolicyRoles() {
            return this.policyRoles != null ? (Collection)this.policyRoles.stream().map(PolicyRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(PolicyRole ... policyRoles) {
            this.policyRoles(Arrays.asList(policyRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(Consumer<PolicyRole.Builder> ... policyRoles) {
            this.policyRoles(Stream.of(policyRoles).map(c -> (PolicyRole)((PolicyRole.Builder)PolicyRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyRoles(Collection<PolicyRole.BuilderImpl> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copyFromBuilder(policyRoles);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListEntitiesForPolicyResponse build() {
            return new ListEntitiesForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    CopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
        public Builder policyGroups(Collection<PolicyGroup> var1);

        public Builder policyGroups(PolicyGroup ... var1);

        public Builder policyGroups(Consumer<PolicyGroup.Builder> ... var1);

        public Builder policyUsers(Collection<PolicyUser> var1);

        public Builder policyUsers(PolicyUser ... var1);

        public Builder policyUsers(Consumer<PolicyUser.Builder> ... var1);

        public Builder policyRoles(Collection<PolicyRole> var1);

        public Builder policyRoles(PolicyRole ... var1);

        public Builder policyRoles(Consumer<PolicyRole.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

