/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.EncodingType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSshPublicKeyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetSshPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String encoding;

    private GetSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.encoding = builder.encoding;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public EncodingType encoding() {
        return EncodingType.fromValue(this.encoding);
    }

    public String encodingAsString() {
        return this.encoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSshPublicKeyRequest)) {
            return false;
        }
        GetSshPublicKeyRequest other = (GetSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyId(), other.sshPublicKeyId()) && Objects.equals(this.encodingAsString(), other.encodingAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetSshPublicKeyRequest").add("UserName", (Object)this.userName()).add("SSHPublicKeyId", (Object)this.sshPublicKeyId()).add("Encoding", (Object)this.encodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyId()));
            }
            case "Encoding": {
                return Optional.ofNullable(clazz.cast(this.encodingAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSshPublicKeyRequest model) {
            super(model);
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.encoding(model.encoding);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(EncodingType encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSshPublicKeyRequest build() {
            return new GetSshPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, GetSshPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder encoding(String var1);

        public Builder encoding(EncodingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

