/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceLinkedRoleRequest
extends IamRequest
implements ToCopyableBuilder<Builder, CreateServiceLinkedRoleRequest> {
    private final String awsServiceName;
    private final String description;
    private final String customSuffix;

    private CreateServiceLinkedRoleRequest(BuilderImpl builder) {
        super(builder);
        this.awsServiceName = builder.awsServiceName;
        this.description = builder.description;
        this.customSuffix = builder.customSuffix;
    }

    public String awsServiceName() {
        return this.awsServiceName;
    }

    public String description() {
        return this.description;
    }

    public String customSuffix() {
        return this.customSuffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSuffix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceLinkedRoleRequest)) {
            return false;
        }
        CreateServiceLinkedRoleRequest other = (CreateServiceLinkedRoleRequest)((Object)obj);
        return Objects.equals(this.awsServiceName(), other.awsServiceName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.customSuffix(), other.customSuffix());
    }

    public String toString() {
        return ToString.builder((String)"CreateServiceLinkedRoleRequest").add("AWSServiceName", (Object)this.awsServiceName()).add("Description", (Object)this.description()).add("CustomSuffix", (Object)this.customSuffix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSServiceName": {
                return Optional.ofNullable(clazz.cast(this.awsServiceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CustomSuffix": {
                return Optional.ofNullable(clazz.cast(this.customSuffix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String awsServiceName;
        private String description;
        private String customSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceLinkedRoleRequest model) {
            super(model);
            this.awsServiceName(model.awsServiceName);
            this.description(model.description);
            this.customSuffix(model.customSuffix);
        }

        public final String getAWSServiceName() {
            return this.awsServiceName;
        }

        @Override
        public final Builder awsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
            return this;
        }

        public final void setAWSServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCustomSuffix() {
            return this.customSuffix;
        }

        @Override
        public final Builder customSuffix(String customSuffix) {
            this.customSuffix = customSuffix;
            return this;
        }

        public final void setCustomSuffix(String customSuffix) {
            this.customSuffix = customSuffix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceLinkedRoleRequest build() {
            return new CreateServiceLinkedRoleRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, CreateServiceLinkedRoleRequest> {
        public Builder awsServiceName(String var1);

        public Builder description(String var1);

        public Builder customSuffix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

