/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;

public class PutRolePolicyRequestMarshaller
implements Marshaller<Request<PutRolePolicyRequest>, PutRolePolicyRequest> {
    public Request<PutRolePolicyRequest> marshall(PutRolePolicyRequest putRolePolicyRequest) {
        if (putRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)putRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "PutRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)putRolePolicyRequest.roleName()));
        }
        if (putRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putRolePolicyRequest.policyName()));
        }
        if (putRolePolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)putRolePolicyRequest.policyDocument()));
        }
        return request;
    }
}

