/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.User;

public class ListUsersIterable
implements SdkIterable<ListUsersResponse> {
    private final IAMClient client;
    private final ListUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsersIterable(IAMClient client, ListUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public Iterator<ListUsersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<User> users() {
        Function<ListUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListUsersIterable resume(ListUsersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListUsersIterable(this.client, (ListUsersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListUsersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListUsersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListUsersResponseFetcher
    implements SyncPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListUsersResponse nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersIterable.this.client.listUsers(ListUsersIterable.this.firstRequest);
            }
            return ListUsersIterable.this.client.listUsers((ListUsersRequest)((Object)ListUsersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

