/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;

public class ListSSHPublicKeysPublisher
implements SdkPublisher<ListSSHPublicKeysResponse> {
    private final IAMAsyncClient client;
    private final ListSSHPublicKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSSHPublicKeysPublisher(IAMAsyncClient client, ListSSHPublicKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSSHPublicKeysPublisher(IAMAsyncClient client, ListSSHPublicKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSSHPublicKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSSHPublicKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<SSHPublicKeyMetadata> sshPublicKeys() {
        Function<ListSSHPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.sshPublicKeys() != null) {
                return response.sshPublicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListSSHPublicKeysResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListSSHPublicKeysPublisher resume(ListSSHPublicKeysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSSHPublicKeysPublisher(this.client, (ListSSHPublicKeysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListSSHPublicKeysPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSSHPublicKeysResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSSHPublicKeysResponseFetcher
    implements AsyncPageFetcher<ListSSHPublicKeysResponse> {
        private ListSSHPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSSHPublicKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListSSHPublicKeysResponse> nextPage(ListSSHPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSSHPublicKeysPublisher.this.client.listSSHPublicKeys(ListSSHPublicKeysPublisher.this.firstRequest);
            }
            return ListSSHPublicKeysPublisher.this.client.listSSHPublicKeys((ListSSHPublicKeysRequest)((Object)ListSSHPublicKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

