/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.Policy;

public class ListPoliciesPublisher
implements SdkPublisher<ListPoliciesResponse> {
    private final IAMAsyncClient client;
    private final ListPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoliciesPublisher(IAMAsyncClient client, ListPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoliciesPublisher(IAMAsyncClient client, ListPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Policy> policies() {
        Function<ListPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListPoliciesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListPoliciesPublisher resume(ListPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPoliciesPublisher(this.client, (ListPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPoliciesResponseFetcher
    implements AsyncPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListPoliciesResponse> nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesPublisher.this.client.listPolicies(ListPoliciesPublisher.this.firstRequest);
            }
            return ListPoliciesPublisher.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

