/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;

public class ListMFADevicesPublisher
implements SdkPublisher<ListMFADevicesResponse> {
    private final IAMAsyncClient client;
    private final ListMFADevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMFADevicesPublisher(IAMAsyncClient client, ListMFADevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMFADevicesPublisher(IAMAsyncClient client, ListMFADevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMFADevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMFADevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<MFADevice> mfaDevices() {
        Function<ListMFADevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.mfaDevices() != null) {
                return response.mfaDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListMFADevicesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListMFADevicesPublisher resume(ListMFADevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMFADevicesPublisher(this.client, (ListMFADevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListMFADevicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListMFADevicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListMFADevicesResponseFetcher
    implements AsyncPageFetcher<ListMFADevicesResponse> {
        private ListMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListMFADevicesResponse> nextPage(ListMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListMFADevicesPublisher.this.client.listMFADevices(ListMFADevicesPublisher.this.firstRequest);
            }
            return ListMFADevicesPublisher.this.client.listMFADevices((ListMFADevicesRequest)((Object)ListMFADevicesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

