/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;

public class ListAccountAliasesIterable
implements SdkIterable<ListAccountAliasesResponse> {
    private final IAMClient client;
    private final ListAccountAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAliasesIterable(IAMClient client, ListAccountAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountAliasesResponseFetcher();
    }

    public Iterator<ListAccountAliasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> accountAliases() {
        Function<ListAccountAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAliases() != null) {
                return response.accountAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListAccountAliasesIterable resume(ListAccountAliasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccountAliasesIterable(this.client, (ListAccountAliasesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAccountAliasesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAccountAliasesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAccountAliasesResponseFetcher
    implements SyncPageFetcher<ListAccountAliasesResponse> {
        private ListAccountAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAliasesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAccountAliasesResponse nextPage(ListAccountAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAliasesIterable.this.client.listAccountAliases(ListAccountAliasesIterable.this.firstRequest);
            }
            return ListAccountAliasesIterable.this.client.listAccountAliases((ListAccountAliasesRequest)((Object)ListAccountAliasesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

