/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAssumeRolePolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, UpdateAssumeRolePolicyRequest> {
    private final String roleName;
    private final String policyDocument;

    private UpdateAssumeRolePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.policyDocument = builder.policyDocument;
    }

    public String roleName() {
        return this.roleName;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssumeRolePolicyRequest)) {
            return false;
        }
        UpdateAssumeRolePolicyRequest other = (UpdateAssumeRolePolicyRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAssumeRolePolicyRequest").add("RoleName", (Object)this.roleName()).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String roleName;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssumeRolePolicyRequest model) {
            super(model);
            this.roleName(model.roleName);
            this.policyDocument(model.policyDocument);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssumeRolePolicyRequest build() {
            return new UpdateAssumeRolePolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, UpdateAssumeRolePolicyRequest> {
        public Builder roleName(String var1);

        public Builder policyDocument(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

