/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyListTypeCopier;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSSHPublicKeysResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListSSHPublicKeysResponse> {
    private final List<SSHPublicKeyMetadata> sshPublicKeys;
    private final Boolean isTruncated;
    private final String marker;

    private ListSSHPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.sshPublicKeys = builder.sshPublicKeys;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<SSHPublicKeyMetadata> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSSHPublicKeysResponse)) {
            return false;
        }
        ListSSHPublicKeysResponse other = (ListSSHPublicKeysResponse)((Object)obj);
        return Objects.equals(this.sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListSSHPublicKeysResponse").add("SSHPublicKeys", this.sshPublicKeys()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSHPublicKeys": {
                return Optional.of(clazz.cast(this.sshPublicKeys()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<SSHPublicKeyMetadata> sshPublicKeys;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSSHPublicKeysResponse model) {
            super(model);
            this.sshPublicKeys(model.sshPublicKeys);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<SSHPublicKeyMetadata.Builder> getSSHPublicKeys() {
            return this.sshPublicKeys != null ? (Collection)this.sshPublicKeys.stream().map(SSHPublicKeyMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SSHPublicKeyMetadata ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(Consumer<SSHPublicKeyMetadata.Builder> ... sshPublicKeys) {
            this.sshPublicKeys(Stream.of(sshPublicKeys).map(c -> (SSHPublicKeyMetadata)((SSHPublicKeyMetadata.Builder)SSHPublicKeyMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSSHPublicKeys(Collection<SSHPublicKeyMetadata.BuilderImpl> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copyFromBuilder(sshPublicKeys);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListSSHPublicKeysResponse build() {
            return new ListSSHPublicKeysResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListSSHPublicKeysResponse> {
        public Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> var1);

        public Builder sshPublicKeys(SSHPublicKeyMetadata ... var1);

        public Builder sshPublicKeys(Consumer<SSHPublicKeyMetadata.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

