/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttachedUserPoliciesResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
    private final List<AttachedPolicy> attachedPolicies;
    private final Boolean isTruncated;
    private final String marker;

    private ListAttachedUserPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.attachedPolicies = builder.attachedPolicies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<AttachedPolicy> attachedPolicies() {
        return this.attachedPolicies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedUserPoliciesResponse)) {
            return false;
        }
        ListAttachedUserPoliciesResponse other = (ListAttachedUserPoliciesResponse)((Object)obj);
        return Objects.equals(this.attachedPolicies(), other.attachedPolicies()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListAttachedUserPoliciesResponse").add("AttachedPolicies", this.attachedPolicies()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicies": {
                return Optional.of(clazz.cast(this.attachedPolicies()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<AttachedPolicy> attachedPolicies;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedUserPoliciesResponse model) {
            super(model);
            this.attachedPolicies(model.attachedPolicies);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedPolicies() {
            return this.attachedPolicies != null ? (Collection)this.attachedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedPolicies(Collection<AttachedPolicy> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copy(attachedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(AttachedPolicy ... attachedPolicies) {
            this.attachedPolicies(Arrays.asList(attachedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(Consumer<AttachedPolicy.Builder> ... attachedPolicies) {
            this.attachedPolicies(Stream.of(attachedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedPolicies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListAttachedUserPoliciesResponse build() {
            return new ListAttachedUserPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
        public Builder attachedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedPolicies(AttachedPolicy ... var1);

        public Builder attachedPolicies(Consumer<AttachedPolicy.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

