/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSAMLProviderRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, CreateSAMLProviderRequest> {
    private final String samlMetadataDocument;
    private final String name;

    private CreateSAMLProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.name = builder.name;
    }

    public String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSAMLProviderRequest)) {
            return false;
        }
        CreateSAMLProviderRequest other = (CreateSAMLProviderRequest)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateSAMLProviderRequest").add("SAMLMetadataDocument", (Object)this.samlMetadataDocument()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.of(clazz.cast(this.samlMetadataDocument()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSAMLProviderRequest model) {
            super(model);
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.name(model.name);
        }

        public final String getSAMLMetadataDocument() {
            return this.samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final void setSAMLMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateSAMLProviderRequest build() {
            return new CreateSAMLProviderRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, CreateSAMLProviderRequest> {
        public Builder samlMetadataDocument(String var1);

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

