/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.services.iam.model._clientIDListTypeCopier;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateOpenIDConnectProviderRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, CreateOpenIDConnectProviderRequest> {
    private final String url;
    private final List<String> clientIDList;
    private final List<String> thumbprintList;

    private CreateOpenIDConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
    }

    public String url() {
        return this.url;
    }

    public List<String> clientIDList() {
        return this.clientIDList;
    }

    public List<String> thumbprintList() {
        return this.thumbprintList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIDList());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprintList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpenIDConnectProviderRequest)) {
            return false;
        }
        CreateOpenIDConnectProviderRequest other = (CreateOpenIDConnectProviderRequest)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.clientIDList(), other.clientIDList()) && Objects.equals(this.thumbprintList(), other.thumbprintList());
    }

    public String toString() {
        return ToString.builder((String)"CreateOpenIDConnectProviderRequest").add("Url", (Object)this.url()).add("ClientIDList", this.clientIDList()).add("ThumbprintList", this.thumbprintList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "ClientIDList": {
                return Optional.of(clazz.cast(this.clientIDList()));
            }
            case "ThumbprintList": {
                return Optional.of(clazz.cast(this.thumbprintList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String url;
        private List<String> clientIDList;
        private List<String> thumbprintList;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpenIDConnectProviderRequest model) {
            super(model);
            this.url(model.url);
            this.clientIDList(model.clientIDList);
            this.thumbprintList(model.thumbprintList);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getClientIDList() {
            return this.clientIDList;
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String ... clientIDList) {
            this.clientIDList(Arrays.asList(clientIDList));
            return this;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        public final Collection<String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            this.thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateOpenIDConnectProviderRequest build() {
            return new CreateOpenIDConnectProviderRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, CreateOpenIDConnectProviderRequest> {
        public Builder url(String var1);

        public Builder clientIDList(Collection<String> var1);

        public Builder clientIDList(String ... var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

