/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateUserRequestMarshaller
implements Marshaller<Request<UpdateUserRequest>, UpdateUserRequest> {
    public Request<UpdateUserRequest> marshall(UpdateUserRequest updateUserRequest) {
        if (updateUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserRequest, "IAMClient");
        request.addParameter("Action", "UpdateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateUserRequest.userName()));
        }
        if (updateUserRequest.newPath() != null) {
            request.addParameter("NewPath", StringUtils.fromString((String)updateUserRequest.newPath()));
        }
        if (updateUserRequest.newUserName() != null) {
            request.addParameter("NewUserName", StringUtils.fromString((String)updateUserRequest.newUserName()));
        }
        return request;
    }
}

