/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateAccessKeyRequestMarshaller
implements Marshaller<Request<UpdateAccessKeyRequest>, UpdateAccessKeyRequest> {
    public Request<UpdateAccessKeyRequest> marshall(UpdateAccessKeyRequest updateAccessKeyRequest) {
        if (updateAccessKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAccessKeyRequest, "IAMClient");
        request.addParameter("Action", "UpdateAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateAccessKeyRequest.userName()));
        }
        if (updateAccessKeyRequest.accessKeyId() != null) {
            request.addParameter("AccessKeyId", StringUtils.fromString((String)updateAccessKeyRequest.accessKeyId()));
        }
        if (updateAccessKeyRequest.status() != null) {
            request.addParameter("Status", StringUtils.fromString((String)updateAccessKeyRequest.status()));
        }
        return request;
    }
}

