/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        SdkInternalList contextEntriesList;
        SdkInternalList resourceArnsList;
        SdkInternalList actionNamesList;
        if (simulateCustomPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)simulateCustomPolicyRequest, "IAMClient");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList policyInputListList = (SdkInternalList)simulateCustomPolicyRequest.policyInputList();
        if (!policyInputListList.isEmpty() || !policyInputListList.isAutoConstruct()) {
            int policyInputListListIndex = 1;
            for (Object policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (!(actionNamesList = (SdkInternalList)simulateCustomPolicyRequest.actionNames()).isEmpty() || !actionNamesList.isAutoConstruct()) {
            int actionNamesListIndex = 1;
            for (Object actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (!(resourceArnsList = (SdkInternalList)simulateCustomPolicyRequest.resourceArns()).isEmpty() || !resourceArnsList.isAutoConstruct()) {
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulateCustomPolicyRequest.resourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString((String)simulateCustomPolicyRequest.resourcePolicy()));
        }
        if (simulateCustomPolicyRequest.resourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)simulateCustomPolicyRequest.resourceOwner()));
        }
        if (simulateCustomPolicyRequest.callerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString((String)simulateCustomPolicyRequest.callerArn()));
        }
        if (!(contextEntriesList = (SdkInternalList)simulateCustomPolicyRequest.contextEntries()).isEmpty() || !contextEntriesList.isAutoConstruct()) {
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                SdkInternalList contextKeyValuesList;
                if (contextEntriesListValue.contextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString((String)contextEntriesListValue.contextKeyName()));
                }
                if (!(contextKeyValuesList = (SdkInternalList)contextEntriesListValue.contextKeyValues()).isEmpty() || !contextKeyValuesList.isAutoConstruct()) {
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.contextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString((String)contextEntriesListValue.contextKeyType()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulateCustomPolicyRequest.resourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString((String)simulateCustomPolicyRequest.resourceHandlingOption()));
        }
        if (simulateCustomPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulateCustomPolicyRequest.maxItems()));
        }
        if (simulateCustomPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulateCustomPolicyRequest.marker()));
        }
        return request;
    }
}

