/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListUsersRequestMarshaller
implements Marshaller<Request<ListUsersRequest>, ListUsersRequest> {
    public Request<ListUsersRequest> marshall(ListUsersRequest listUsersRequest) {
        if (listUsersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listUsersRequest, "IAMClient");
        request.addParameter("Action", "ListUsers");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listUsersRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listUsersRequest.pathPrefix()));
        }
        if (listUsersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listUsersRequest.marker()));
        }
        if (listUsersRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listUsersRequest.maxItems()));
        }
        return request;
    }
}

