/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListPolicyVersionsRequest>, ListPolicyVersionsRequest> {
    public Request<ListPolicyVersionsRequest> marshall(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        if (listPolicyVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPolicyVersionsRequest, "IAMClient");
        request.addParameter("Action", "ListPolicyVersions");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPolicyVersionsRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)listPolicyVersionsRequest.policyArn()));
        }
        if (listPolicyVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listPolicyVersionsRequest.marker()));
        }
        if (listPolicyVersionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listPolicyVersionsRequest.maxItems()));
        }
        return request;
    }
}

